/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX__HANDLE_MAP_H
#define MX__HANDLE_MAP_H

union mx_request;

union mx__hm_item
{
  union mx_request *r;
  int i;
};

struct mx__handle_map
{
  union mx__hm_item *map;
  int free_count;
  int first_free;
  int last_free;
  int total_count;
  int reserved_count;
};

struct mx__handle_map *mx__hm_init(int count, int reserved);
void mx__hm_fini(struct mx__handle_map *hm);

static inline
int mx__hm_avail(struct mx__handle_map *hm)
{
  /* always keep one "shandle" free for the wake event */
  return likely(hm->free_count > hm->reserved_count);
}

static inline
int mx__hm_alloc(struct mx__handle_map *hm)
{
  int i;

  mx_assert (hm->free_count > 0);
  i = hm->first_free;
  mx_assert(i >=0 && i < hm->total_count);
  hm->first_free = hm->map[i].i;
  hm->free_count--;
  if (unlikely(hm->free_count == 0)) {
    mx_assert(hm->last_free == i);
    hm->last_free = -1;
    mx_assert(hm->first_free == -1);
  }
  return i;
}

static inline
void mx__hm_free(struct mx__handle_map *hm, int i)
{
  mx_assert(i >=0 && i < hm->total_count);
  if (hm->free_count == 0) {
    mx_assert(hm->last_free == -1 && hm->first_free == -1);
    hm->first_free = i;
  } else {
    hm->map[hm->last_free].i = i;
  }
  hm->last_free = i;
  hm->map[i].i = -1;
  hm->free_count++;
}

static inline
void mx__hm_set(struct mx__handle_map *hm, int i, union mx_request *r)
{
  mx_assert(i >=0 && i < hm->total_count);
  hm->map[i].r = r;
}

static inline
union mx_request *mx__hm_get(struct mx__handle_map *hm, int i)
{
  mx_assert(i >=0 && i < hm->total_count);
  return hm->map[i].r;
}


#endif
